<!DOCTYPE html PUBLIC
    "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
    "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:svg="http://www.w3.org/2000/svg"
      xmlns:xlink="http://www.w3.org/1999/xlink" xml:lang="en">
<head>
<title>Painting the Web: Adventures in Graphics</title>
<meta http-equiv="X-UA-Compatible" content="IE=7" />
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
<link rel="stylesheet" href="../book.css" type="text/css" media="screen" />
</head>
<body>

<div><div id="sidepanel"><h1>Painting the Web</h1>
<img src="../svg2raster3.png" alt="Painting the Web book cover on easel"  /></div>

<div id="content">

<div id="header">
<ul>
<li><a href="../.">Main Examples</a></li>
</ul>
</div>

<div id="entry">
<p><?php

// Losowe wybieranie pliku JPG z bieżącego katalogu, wydrukowanie danych EXIF, obrazu i opisu aparatu

$exts = array('jpg');

//Pobiera listę plików w bieżącym katalogu
//Zmiany zasugerowane przez Kaf Oseo
$url = array();
if($handle = opendir(dirname(__FILE__))) {
        while(false !== ($image = readdir($handle)))
                foreach($exts as $ext)
                        if(strstr($image, '.' . $ext))
                                $url[] = $image;
        closedir($handle);
}

//Generuje liczbę losową
srand((double)microtime() * 1000000);

// Liczba zdjęć
$ct = count($url);

// Losowe wybranie numeru zdjęcia
$rn = (rand()%$ct);

// Pobiera nazwę zdjęcia
$file = trim($url[$rn]);

if (file_exists($file))
   $exif = exif_read_data($file, 0, true) ;
else
 exit("Not a valid file directory and/or file");
echo "$file:<br />\n";
echo "<a href='xmp.php?photo=$file'>XMP data</a><br />\n";
echo "<img src='$file' alt='$file' style='width: 500px' /><br /><br />";
foreach ($exif as $key => $section) {
    foreach ($section as $name => $val) {
        echo "$key.$name: $val<br />\n";
        if ($name == 'Model') {
          $val = str_replace(" ","_",$val);
          echo "<img src='$val.png' alt='$val' /><br /><br />";
        }
    }
}
?>
</p>
</div>

</div>
</div>
</body>
</html>

